//=============================================================================
// BigDragonPet.
//=============================================================================
class BigDragonPet extends Pets;

var localized String MsgNoDragon;

state Activated
{
	function Activate()
	{
	}

	function BeginState()
	{
		local DeusExPlayer P;
                		local Vector loc;
		local BigDragonCompanion D;
	
		Super.BeginState(); 

                		P = DeusExPlayer(Owner);
                		if ( P != None )    
                		{            
                      		D = Spawn(Class'BigDragonCompanion',P,,P.Location + (P.CollisionRadius+Class'DragonCompanion'.Default.CollisionRadius+30) * Vector(P.ViewRotation) + vect(0,0,1) * 30 );
			if ( D != None )
			{
                      			D.PlaySound(None);
                      			UseOnce();
			}
			else
			{
				P.ClientMessage(MsgNoDragon);
				GotoState('DeActivated');
			}
                		}
	}
Begin:
}

defaultproperties
{
     MsgNoDragon="|p2Dragon can not be released here."
     InventoryGroup=190
     bActivatable=True
     ItemName="Big Dragon Pet"
     PlayerViewOffset=(X=20.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExCharacters.Greasel'
     PlayerViewScale=1.125000
     PickupViewMesh=LodMesh'DeusExCharacters.Greasel'
     PickupViewScale=1.500000
     ThirdPersonMesh=LodMesh'DeusExCharacters.Greasel'
     ThirdPersonScale=1.500000
     LandSound=Sound'DeusExSounds.Animal.GreaselFootstep'
     Icon=Texture'Markistan.Icons.BeltIconDragonPet'
     largeIcon=Texture'Markistan.Icons.InventoryIconBigDragonPet'
     largeIconWidth=90
     largeIconHeight=90
     invSlotsX=2
     invSlotsY=2
     Description="A big dragon that seems to like you, it's small enough to fit in your bag, and easily big enough to stand a threat and protect you."
     beltDescription="BIG DRAGON"
     Skin=Texture'Markistan.Skins.DragonTex1'
     Mesh=LodMesh'DeusExCharacters.Greasel'
     DrawScale=0.750000
     CollisionRadius=32.000000
     CollisionHeight=24.879999
     Mass=50.000000
     Buoyancy=100.000000
}
